#version 330
#extension GL_EXT_gpu_shader4 : enable
//Shadertober 21 TreasureMod01.fsh  by   GreenChicken

//https://www.shadertoy.com/view/WdtXRM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// SHADERTOBER 21 Treasure
// Poulet vert 21-10-2019
// Thanks iq, leon, everybody yeah yeah

#define PI 3.14159
#define MAXSTEP 64

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

float ThirdRules(vec2 uv)
{
    float r = 0.; // final rule output
    float rs = 0.005; // rule line size
    float ds = 0.5; // dot size
    
    float hr = 0.0;
    hr = step(fract(uv.x * 3.), rs);
    hr *= 1. - step(uv.x, .1);
    float d = step(fract(uv.y * 100.), ds);
    hr = min(hr, d);
    
    float vr = 0.0;
    d = step(fract(uv.x * 100.), ds);
    vr = min(step(fract(uv.y * 3.), rs), d);
    vr *= 1. - step(uv.y, .1);
    
    return max(hr, vr);
}


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

mat2 rot (float a) { float c=cos(a),s=sin(a); return mat2(c,-s,s,c); }

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0))
         + min(max(d.x,max(d.y,d.z)),0.0); 
}


vec3 opRep(vec3 p, vec3 c)
{
     return mod(p+0.5*c,c)-0.5*c;
}

vec2 opU2( vec2 d1, vec2 d2 )
{
    return (d1.x < d2.x) ? d1 : d2;
}


vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

float sdCappedCylinder( vec3 p, float h, float r )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - vec2(h,r);
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdTriPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max(q.x*0.866025+p.y*0.5,-p.y)-h.x*0.5);
}

// Scene setup
vec2 map(vec3 pos)
{
    vec2 scene = vec2(0.0, 0.0);
    
    float time = iTime*4.0;
    
    pos.z += time;
    
    vec3 cubP = pos + vec3(0.0);
    cubP = opRep(cubP, vec3(0.0, 0.0, 1.0));
    float world = sdBox(cubP, vec3(1.0));
    
    vec3 triP = pos + vec3(0.0);
    triP = opRep(triP, vec3(0.0, 0.0, 1.0));
    float tri = sdTriPrism(triP, vec2(1.0, 2.0));
    
    world = max(world, -tri);
    
    triP = pos + vec3(0.0, 0.0, 0.0);
    triP.xz *= rot(PI/2.0);
    triP = opRep(triP, vec3(5.0, 0.0, 0.0));
    tri = sdTriPrism(triP, vec2(1.0, 2.0));
    
    world = max(world, -tri);
    
    // glogofkdgkdfjgkj
    vec3 fckP = pos + vec3(0.0, 0.0, time*2.0);
    fckP = opRep(fckP, vec3(0.0, 0.0, 10.0));
    float fck = sdTriPrism(fckP, vec2(.5, .01));
    fckP = pos + vec3(0.0, 0.0, time*2.0);
    fckP = opRep(fckP, vec3(0.0, 0.0, 10.0));
    fck = max(fck, -sdTriPrism(fckP, vec2(.4, .6)));
    
    // materials
    scene = vec2(world, 0.0);
    scene = opU2(scene,vec2(fck, 1.0));
    
    return scene;
}

vec2 CastRay(vec3 ro, vec3 rd)
{
    float t = 0.0;
    
    for(int i=0 ; i<128 ; i++)
    {
        vec2 ray = map(ro + rd * t);
        
        if(ray.x < (0.0001*t))
        {
            return vec2(float(i)/128., ray.y);
        }
        
        t += ray.x;
    }
    
    return vec2(-1.0, 0.0);
}

vec3 Render(vec3 ro, vec3 rd, vec2 uv)
{
    vec2 t = CastRay(ro, rd);
    vec3 pos = vec3(ro + rd * t.x);
    
    vec3 col = vec3(0.0);
    vec3 polyCol = palette(t.x+fract(iTime), vec3(.5), vec3(.5), vec3(1.0), vec3(0.0, 0.33, 0.67));
    
    if(t.x == -1.0)
    {
        
        col = vec3(0.0);
        
    }
    else
    {
        float depth = 1.0 - t.x;
        
        if(t.y == 0.0)
        {
            col = vec3(depth)*.4;
        }
        else if(t.y == 1.0)
        {
            col = polyCol;
        }
    }
    
    return col;
}

vec3 GetViewDir(vec2 uv, vec3 cp, vec3 ct)
{
    vec3 forward = normalize(ct - cp);
    vec3 right = normalize(cross(vec3(sin(iTime)*.5, -1.0, 0.0), forward));
    vec3 up = normalize(cross(right, forward));
    
    return normalize(uv.x * right + uv.y * up + (2.0+sin(iTime)) * forward);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    uv.x *= iResolution.x/iResolution.y;
    vec2 screenUV = gl_FragCoord.xy / iResolution.xy;
    
    vec3 cp = vec3(0.0, 0.0, -5.0);
    vec3 ct = vec3(0.0, sin(iTime)*.2, 0.0);
    
    vec3 vd = GetViewDir(uv, cp, ct);
    
    vec3 col = Render(cp, vd, uv);
    
    col.x -= length(uv)-.5;
    
    col += ThirdRules(screenUV)*.1;
    
    col -= clamp((length(uv))*.2, 0.0, 1.0);
    
    gl_FragColor = vec4(sqrt(clamp(col, 0.0, 1.0)),1.0);
}